unit Form_LibraryEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, BusinessSkinForm, bsSkinCtrls, ComCtrls, StdCtrls, ExtCtrls,
  MMObj, MMPanel, MMFill, abfControls, MMBmpLst, MMBmpBtn, bsfilectrl,
  bsSkinBoxCtrls, Mask, bsSkinShellCtrls, Grids, BaseGrid, AdvGrid,
  AdvCGrid, ShellCtrls, MMDSPObj, MMWavOut, MMPitch, MMAudio,MMMpeg,
  FileCtrl, AdvProgr, DB, mySQLDbTables;

type
  Tlib_editor = class(TForm)
    bsBusinessSkinForm1: TbsBusinessSkinForm;
    bsSkinPanel6: TbsSkinPanel;
    musiclib: TbsSkinButton;
    bsSkinButton3: TbsSkinButton;
    bsSkinButton4: TbsSkinButton;
    bsSkinButton5: TbsSkinButton;
    bsSkinButton7: TbsSkinButton;
    bsSkinButton8: TbsSkinButton;
    bsSkinPanel1: TbsSkinPanel;
    bsSkinPanel3: TbsSkinPanel;
    bsSkinPanel2: TbsSkinPanel;
    MusicExplorer: TbsSkinPanel;
    MMPanelFill9: TMMPanelFill;
    Label1: TLabel;
    MusicLibTree: TbsSkinTreeView;
    bsSkinScrollBar1: TbsSkinScrollBar;
    bsSkinPanel4: TbsSkinPanel;
    MMPanelFill5: TMMPanelFill;
    btnremove: TMMBitmapButton;
    MMPanelFill1: TMMPanelFill;
    MMPanelFill3: TMMPanelFill;
    MMPanelFill6: TMMPanelFill;
    MMBitmapButton3: TMMBitmapButton;
    MMBitmapButton4: TMMBitmapButton;
    MMPanelFill7: TMMPanelFill;
    Path: TStaticText;
    StaticText3: TStaticText;
    abfEdit1: TabfEdit;
    MMPanelFill8: TMMPanelFill;
    MMPanelFill10: TMMPanelFill;
    StaticText2: TStaticText;
    StaticText4: TStaticText;
    path_text: TStaticText;
    MMPanelFill11: TMMPanelFill;
    Bevel1: TBevel;
    MMBitmapButton1: TMMBitmapButton;
    MMBitmapButton2: TMMBitmapButton;
    MMBitmapButton5: TMMBitmapButton;
    MMBitmapButton6: TMMBitmapButton;
    Memo1: TMemo;
    filelistbox: TbsSkinFileListView;
    dir: TbsSkinDirTreeView;
    MMPanelFill2: TMMPanelFill;
    bsSkinShellComboBox1: TbsSkinShellComboBox;
    bsSkinScrollBar2: TbsSkinScrollBar;
    bsSkinScrollBar3: TbsSkinScrollBar;
    bsSkinScrollBar4: TbsSkinScrollBar;
    bsSkinScrollBar5: TbsSkinScrollBar;
    MMPanelFill15: TMMPanelFill;
    Label3: TLabel;
    MMPanelFill16: TMMPanelFill;
    btn_play: TMMBitmapButton;
    btn_stop: TMMBitmapButton;
    bsSkinButton1: TbsSkinButton;
    chk1: TCheckBox;
    mmo1: TMemo;
    MMBitmapButton7: TMMBitmapButton;
    bsSkinScrollBar6: TbsSkinScrollBar;
    MMBitmapButton8: TMMBitmapButton;
    fllst1: TFileListBox;
    tmr_tmr: TTimer;
    tmr1: TTimer;
    tmr2: TTimer;
    tmr3: TTimer;
    mpegfile1: TMMMPEGFile;
    treeGrid: TAdvColumnGrid;
    chk2: TCheckBox;
    lst1: TListBox;
    lbl1: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMBitmapButton3Click(Sender: TObject);
    procedure musiclibClick(Sender: TObject);
    procedure dirChange(Sender: TObject; Node: TTreeNode);
    procedure dirClick(Sender: TObject);
    procedure MMBitmapButton4Click(Sender: TObject);
    procedure btnremoveClick(Sender: TObject);
    procedure MMBitmapButton2Click(Sender: TObject);
    procedure MMBitmapButton5Click(Sender: TObject);
    procedure MMBitmapButton1Click(Sender: TObject);
    procedure MMBitmapButton6Click(Sender: TObject);
    procedure MusicLibTreeChange(Sender: TObject; Node: TTreeNode);
    procedure bsSkinButton3Click(Sender: TObject);
    procedure bsSkinButton4Click(Sender: TObject);
    procedure bsSkinButton5Click(Sender: TObject);
    procedure bsSkinButton7Click(Sender: TObject);
    procedure bsSkinButton8Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btn_playClick(Sender: TObject);
    procedure btn_stopClick(Sender: TObject);
    procedure bsSkinButton1Click(Sender: TObject);
    procedure MMBitmapButton7Click(Sender: TObject);
    procedure MMBitmapButton8Click(Sender: TObject);
    procedure tmr_tmrTimer(Sender: TObject);
    procedure tmr1Timer(Sender: TObject);
    procedure tmr2Timer(Sender: TObject);
    procedure tmr3Timer(Sender: TObject);
  private
    { Private declarations }
    procedure reload_all;
    procedure delete_data;
    procedure reloadlib(namegrid:string);
    procedure update_treegrid(namegrid:string);
  public
    { Public declarations }
  end;

var
  lib_editor: Tlib_editor;
  edits:boolean;
  namegrids:string;

implementation

uses form_mainform, Form_songLibrary, form_progress;

{$R *.dfm}

procedure Tlib_editor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  width:=0;
  height:=0;
  lib_editor.FormStyle:=fsnormal;
  lib_editor.Visible:=false;
  mainform.AutoArrange1.Click;
end;

procedure drawtree(filename:string);
var i,j:integer;
    space:string;
begin
  DeleteFile(savedir+'temp');

  lib_editor.memo1.Lines.Clear;

  lib_editor.MusicLibTree.Items.Clear;
  lib_editor.MusicLibTree.Update;
  lib_editor.MusicLibTree.Refresh;

  if lib_editor.treeGrid.RowCount<2 then lib_editor.treeGrid.RowCount:=2;

  if filename<>'' then
  begin
  with lib_editor do
  begin
   memo1.Lines.Clear;

   if treeGrid.Cells[0,1]<>'' then
   for i:=1 to treegrid.RowCount-1 do
   begin
      if treegrid.Cells[2,i]<>'' then
      begin
        space:='';
        if strtoint(treegrid.Cells[2,i])>1 then
        begin
          for j:=1 to strtoint(treegrid.Cells[2,i])-1 do
          begin
            space:=space+' ';
          end;
        end;
        memo1.Lines.Add(space+treegrid.Cells[0,i]);
      end;
   end else Memo1.Lines.Clear;

   memo1.Lines.SaveToFile(savedir+'temp');
   MusicLibTree.LoadFromFile(savedir+'temp');

   MusicLibTree.Update;
   MusicLibTree.Refresh;
   MusicLibTree.FullExpand;
  end;
  end;
end;

{
procedure GetSubDirectories(const directory : string; list : TStrings) ;
 var
   sr : TSearchRec;
 begin
   try
     if FindFirst(IncludeTrailingPathDelimiter(directory) + '*.*', faDirectory, sr) < 0 then
       Exit
     else
     repeat
       if ((sr.Attr and faDirectory <> 0) AND (sr.Name <> '.') AND (sr.Name <> '..')) then
         List.Add(IncludeTrailingPathDelimiter(directory) + sr.Name) ;
     until FindNext(sr) <> 0;
   finally
     SysUtils.FindClose(sr) ;
   end;
 end;
}

procedure GetSubDirectories(const dir : string);
var
  f : TSearchRec;
  before, after : string;
const
  Success : integer = 0;
begin
  lib_editor.lst1.Items.BeginUpdate; // speeds action in TStrings of listbox
  if FindFirst(Dir + '\*.*', faDirectory, f) = Success then begin
    repeat {until FindNext(f) <> Success}
      if (f.Attr and faDirectory) <> 0 then begin
        if (f.Name[1] <> '.') then begin
          {add directory name to listbox with [  ] around it}
          before := Dir + '\' + f.Name;
          after  := StringReplace(before, '\\', '\',[rfReplaceAll, rfIgnoreCase]);
          lib_editor.lst1.Items.Add(after);
          GetSubDirectories(Dir + '\' + f.Name); // recurses all sub-directories
        end; {if fname not .. or . (ie not this or parent directory)}
        end {f.attr = faDirectory}
      else
        {add filename to listbox}
        //lib_editor.lst1.Items.Add(Dir + '\' + f.Name);
      {end;  if f.attr = fadirectory else}
    until FindNext(f) <> Success;
    FindClose(f);
  end; {if findfirst etc}
  lib_editor.lst1.Items.EndUpdate;  // see note against BeginUpdate
end;






{

procedure GetSubDirectories(const dir : string) ;
  var
    SR    : TSearchRec;
    space : string;
  begin
    if FindFirst(Dir + '*.*', faAnyFile, SR) = 0
      then
        begin
          repeat
            if (SR.Name <> '.') and (SR.Name <> '..')
                then if SR.Attr = faDirectory
                then
                  begin
                    lib_editor.mmo1.Lines.Add(dir+SR.Name);
                    GetSubDirectories(Dir + SR.Name+'\');
                  end
                else
                  begin
                  end;
          until (FindNext(SR) <> 0);
          FindClose(SR);
        end;
  end;
}

function fGetCount(const vvString: String): Integer;
begin
 Result := Length(vvString) - Length(StringReplace(vvString, '\', '', [rfReplaceAll, rfIgnoreCase]));
end;

procedure Tlib_editor.update_treegrid(namegrid:string);
var databases : Tmysqltable ;
    i:integer;
    nama_tabel:string;
begin
   if namegrid='musiclib.dat'       then databases:=mainform.db_treemusic;
   if namegrid='newslib.dat'        then databases:=mainform.tree_news;
   if namegrid='otherslib.dat'      then databases:=mainform.tree_other;
   if namegrid='adlibslib.dat'      then databases:=mainform.tree_adlib;
   if namegrid='commercialslib.dat' then databases:=mainform.tree_commercial;
   if namegrid='jingleslib.dat'     then databases:=mainform.tree_jingle;
   if namegrid='insertlib.dat'      then databases:=mainform.tree_insert;

   if namegrid='musiclib.dat'       then nama_tabel:='tree_music';
   if namegrid='newslib.dat'        then nama_tabel:='tree_news';
   if namegrid='otherslib.dat'      then nama_tabel:='tree_other';
   if namegrid='adlibslib.dat'      then nama_tabel:='tree_adlib';
   if namegrid='commercialslib.dat' then nama_tabel:='tree_commercials';
   if namegrid='jingleslib.dat'     then nama_tabel:='tree_jingle';
   if namegrid='insertlib.dat'      then nama_tabel:='tree_insert';

   //databases.EmptyTable;
   try
      mainform.Query2.SQL.Clear;
      mainform.Query2.SQL.Add('DELETE FROM '+nama_tabel+' WHERE RBO_ID='+lbl1.Caption+RBO_ID+lbl1.Caption);
      mainform.Query2.Active:=true;
      mainform.Query2.Close;
      mainform.Query2.Open;      //mainform.Query2.execsql;
    except on e:exception do begin end; //ShowMessage(e.message)
   end;

   for i:=1 to treeGrid.RowCount-1 do
   begin
     if treeGrid.Cells[0,i]<>'' then
     begin
      databases.Append;
      databases.FieldByName('List').AsString  :=treeGrid.Cells[0,i];
      databases.FieldByName('Path').AsString  :=treeGrid.Cells[1,i];
      databases.FieldByName('Indeks').AsString:=treeGrid.Cells[2,i];
      databases.FieldByName('RBO_ID').AsString:=RBO_ID;
      databases.Post;
     end;
   end;
end;

procedure Tlib_editor.reloadlib(namegrid:string);
var i:integer;
begin
       if namegrid='musiclib.dat' then
       begin
          mainform.db_treemusic.EmptyTable;
          for i:=1 to treeGrid.RowCount-1 do
          begin
            mainform.db_treemusic.Append;
            mainform.db_treemusic.FieldByName('List').AsString  :=treeGrid.Cells[0,i];
            mainform.db_treemusic.FieldByName('Path').AsString  :=treeGrid.Cells[1,i];
            mainform.db_treemusic.FieldByName('Indeks').AsString:=treeGrid.Cells[2,i];
            mainform.db_treemusic.Post;
          end;
          {
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.db_treemusic.Append;
            mainform.db_treemusic.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.db_treemusic.Post;
            reloadform.AdvProgress1.Position:=reloadform.AdvProgress1.Position+1;
          end;
          }
       end;

       if namegrid='newslib.dat' then
       begin
          mainform.tree_news.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_news.Append;
            mainform.tree_news.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_news.Post;
            reloadform.AdvProgress1.Position:=reloadform.AdvProgress1.Position+1;
          end;
       end;

       if namegrid='otherslib.dat' then
       begin
          mainform.tree_other.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_other.Append;
            mainform.tree_other.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_other.Post;
            reloadform.AdvProgress1.Position:=reloadform.AdvProgress1.Position+1;
          end;
       end;

       if namegrid='adlibslib.dat' then
       begin
          mainform.tree_adlib.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_adlib.Append;
            mainform.tree_adlib.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_adlib.Post;
            reloadform.AdvProgress1.Position:=reloadform.AdvProgress1.Position+1;
          end;
       end;

       if namegrid='commercialslib.dat' then
       begin
          mainform.tree_commercial.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_commercial.Append;
            mainform.tree_commercial.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_commercial.Post;
            reloadform.AdvProgress1.Position:=reloadform.AdvProgress1.Position+1;
          end;
       end;

       if namegrid='jingleslib.dat' then
       begin
          mainform.tree_jingle.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_jingle.Append;
            mainform.tree_jingle.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_jingle.Post;
            reloadform.AdvProgress1.Position:=reloadform.AdvProgress1.Position+1;
          end;
       end;

       if namegrid='insertlib.dat' then
       begin
          mainform.tree_insert.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_insert.Append;
            mainform.tree_insert.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_insert.Post;
            reloadform.AdvProgress1.Position:=reloadform.AdvProgress1.Position+1;
          end;
       end;

      //if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);
      reloadform.visible:=false;
      mainform.Enabled:=true;
end;

procedure Tlib_editor.MMBitmapButton3Click(Sender: TObject);
var i:integer;
    namegrid:string;
begin
  if lib_editor.treeGrid.RowCount<2 then lib_editor.treeGrid.RowCount:=2;
  if abfedit1.Text<>'' then
  begin
    reloadform.visible:=True;
    mainform.Enabled:=false;

       if chk1.Checked=True then
       begin
          lst1.Items.Clear;
          GetSubDirectories(path_text.Caption);
          if lst1.Items.Count>0 then
          begin
             for i:=0 to lst1.Items.Count-1 do
             begin
                if treegrid.Cells[0,1]<>'' then treegrid.RowCount:=treegrid.RowCount+1;
                treegrid.Cells[0,treegrid.RowCount-1]:=ExtractFileName(ExcludeTrailingPathDelimiter(lst1.Items.strings[i]));
                treegrid.Cells[1,treegrid.RowCount-1]:=lst1.items.strings[i];
                treegrid.Cells[2,treegrid.RowCount-1]:=IntToStr((fGetCount(lst1.Items.strings[i])-fgetcount(path_text.Caption))+1);
                treegrid.Cells[3,treegrid.RowCount-1]:=RBO_ID;
             end;
          end;
       end else
       begin
          if treegrid.Cells[0,1]<>'' then treegrid.RowCount:=treegrid.RowCount+1;
          treegrid.Cells[0,treegrid.RowCount-1]:=abfedit1.Text;
          treegrid.Cells[1,treegrid.RowCount-1]:=path_text.Caption;
          treegrid.Cells[2,treegrid.RowCount-1]:='1';
          treegrid.Cells[3,treegrid.RowCount-1]:=RBO_ID;
       end;

       if label1.caption='MUSIC LIBRARY'   then namegrid:='musiclib.dat';
       if label1.caption='INSERT LIBRARY'  then namegrid:='insertlib.dat';
       if label1.caption='JINGLES LIBRARY' then namegrid:='jingleslib.dat';
       if label1.caption='COMM LIBRARY'    then namegrid:='commercialslib.dat';
       if label1.caption='ADLIBS LIBRARY'  then namegrid:='adlibslib.dat';
       if label1.caption='NEWS LIBRARY'    then namegrid:='newslib.dat';
       if label1.caption='OTHERS LIBRARY'  then namegrid:='otherslib.dat';


       namegrids:=namegrid;
       drawtree(namegrid);
       update_treegrid(namegrid);
       MusicLibTree.FullCollapse;

       if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);
       reloadform.visible:=false;
       mainform.Enabled:=true;
  end else
  begin
    if languages=0 then mainform.message.MessageDlg('Please type category name!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Ketikan terlebih dahulu kategori yang akan dibuat!',mtconfirmation,[mbok],0);
  end;
end;

Procedure load_treelib(namegrid:string);
var i:Integer;
begin
       lib_editor.MusicLibTree.Items.Clear;
       lib_editor.MusicLibTree.Update;

       lib_editor.Memo1.Lines.Clear;

       if namegrid='musiclib.dat' then
       begin
          mainform.db_treemusic.First;
          lib_editor.treegrid.ClearRows(1,lib_editor.treegrid.RowCount);
          lib_editor.treegrid.RowCount:=2;
          while not mainform.db_treemusic.Eof do
          begin
            if UpperCase(mainform.db_treemusic.FieldByName('RBO_ID').AsString)=UpperCase(RBO_ID) then
            begin
              if  lib_editor.treegrid.cells[0,1]<>'' then  lib_editor.treegrid.rowcount:= lib_editor.treegrid.rowcount+1;
                  lib_editor.treegrid.cells[0,lib_editor.treegrid.rowcount-1]:=mainform.db_treemusic.FieldByName('List').AsString;
                  lib_editor.treegrid.cells[1,lib_editor.treegrid.rowcount-1]:=mainform.db_treemusic.FieldByName('Path').AsString;
                  lib_editor.treegrid.cells[2,lib_editor.treegrid.rowcount-1]:=mainform.db_treemusic.FieldByName('Indeks').AsString;
            end;
            mainform.db_treemusic.Next;
          end;
          {
          while not mainform.db_treemusic.Eof do
          begin
            lib_editor.Memo1.Lines.Add(mainform.db_treemusic.FieldByName('List').AsString);
            mainform.db_treemusic.Next;
          end;
          }
       end;

       if namegrid='newslib.dat' then
       begin
          mainform.tree_news.First;
          lib_editor.treegrid.ClearRows(1,lib_editor.treegrid.RowCount);
          lib_editor.treegrid.RowCount:=2;
          while not mainform.tree_news.Eof do
          begin
            if UpperCase(mainform.tree_news.FieldByName('RBO_ID').AsString)=UpperCase(RBO_ID) then
            begin
              if  lib_editor.treegrid.cells[0,1]<>'' then  lib_editor.treegrid.rowcount:= lib_editor.treegrid.rowcount+1;
                  lib_editor.treegrid.cells[0,lib_editor.treegrid.rowcount-1]:=mainform.tree_news.FieldByName('List').AsString;
                  lib_editor.treegrid.cells[1,lib_editor.treegrid.rowcount-1]:=mainform.tree_news.FieldByName('Path').AsString;
                  lib_editor.treegrid.cells[2,lib_editor.treegrid.rowcount-1]:=mainform.tree_news.FieldByName('Indeks').AsString;
            end;
            mainform.tree_news.Next;
          end;
          {
          mainform.tree_news.First;
          while not mainform.tree_news.Eof do
          begin
            lib_editor.Memo1.Lines.Add(mainform.tree_news.FieldByName('List').AsString);
            mainform.tree_news.Next;
          end;  }
       end;

       if namegrid='otherslib.dat' then
       begin
          mainform.tree_other.First;
          lib_editor.treegrid.ClearRows(1,lib_editor.treegrid.RowCount);
          lib_editor.treegrid.RowCount:=2;
          while not mainform.tree_other.Eof do
          begin
            if UpperCase(mainform.tree_other.FieldByName('RBO_ID').AsString)=UpperCase(RBO_ID) then
            begin
              if  lib_editor.treegrid.cells[0,1]<>'' then  lib_editor.treegrid.rowcount:= lib_editor.treegrid.rowcount+1;
                  lib_editor.treegrid.cells[0,lib_editor.treegrid.rowcount-1]:=mainform.tree_other.FieldByName('List').AsString;
                  lib_editor.treegrid.cells[1,lib_editor.treegrid.rowcount-1]:=mainform.tree_other.FieldByName('Path').AsString;
                  lib_editor.treegrid.cells[2,lib_editor.treegrid.rowcount-1]:=mainform.tree_other.FieldByName('Indeks').AsString;
            end;
            mainform.tree_other.Next;
          end;
          {
          mainform.tree_other.First;
          while not mainform.tree_other.Eof do
          begin
            lib_editor.Memo1.Lines.Add(mainform.tree_other.FieldByName('List').AsString);
            mainform.tree_other.Next;
          end;}
       end;

       if namegrid='adlibslib.dat' then
       begin
          mainform.tree_adlib.First;
          lib_editor.treegrid.ClearRows(1,lib_editor.treegrid.RowCount);
          lib_editor.treegrid.RowCount:=2;
          while not mainform.tree_adlib.Eof do
          begin
            if UpperCase(mainform.tree_adlib.FieldByName('RBO_ID').AsString)=UpperCase(RBO_ID) then
            begin
              if  lib_editor.treegrid.cells[0,1]<>'' then  lib_editor.treegrid.rowcount:= lib_editor.treegrid.rowcount+1;
                  lib_editor.treegrid.cells[0,lib_editor.treegrid.rowcount-1]:=mainform.tree_adlib.FieldByName('List').AsString;
                  lib_editor.treegrid.cells[1,lib_editor.treegrid.rowcount-1]:=mainform.tree_adlib.FieldByName('Path').AsString;
                  lib_editor.treegrid.cells[2,lib_editor.treegrid.rowcount-1]:=mainform.tree_adlib.FieldByName('Indeks').AsString;
            end;
            mainform.tree_adlib.Next;
          end;
          {
          mainform.tree_adlib.First;
          while not mainform.tree_adlib.Eof do
          begin
            lib_editor.Memo1.Lines.Add(mainform.tree_adlib.FieldByName('List').AsString);
            mainform.tree_adlib.Next;
          end;
          }
       end;

       if namegrid='commercialslib.dat' then
       begin
          mainform.tree_commercial.First;
          lib_editor.treegrid.ClearRows(1,lib_editor.treegrid.RowCount);
          lib_editor.treegrid.RowCount:=2;
          while not mainform.tree_commercial.Eof do
          begin
            if UpperCase(mainform.tree_commercial.FieldByName('RBO_ID').AsString)=UpperCase(RBO_ID) then
            begin
              if  lib_editor.treegrid.cells[0,1]<>'' then  lib_editor.treegrid.rowcount:= lib_editor.treegrid.rowcount+1;
                  lib_editor.treegrid.cells[0,lib_editor.treegrid.rowcount-1]:=mainform.tree_commercial.FieldByName('List').AsString;
                  lib_editor.treegrid.cells[1,lib_editor.treegrid.rowcount-1]:=mainform.tree_commercial.FieldByName('Path').AsString;
                  lib_editor.treegrid.cells[2,lib_editor.treegrid.rowcount-1]:=mainform.tree_commercial.FieldByName('Indeks').AsString;
            end;
            mainform.tree_commercial.Next;
          end;
          {
          mainform.tree_commercial.First;
          while not mainform.tree_commercial.Eof do
          begin
            lib_editor.Memo1.Lines.Add(mainform.tree_commercial.FieldByName('List').AsString);
            mainform.tree_commercial.Next;
          end;
          }
       end;

       if namegrid='jingleslib.dat' then
       begin
          mainform.tree_jingle.First;
          lib_editor.treegrid.ClearRows(1,lib_editor.treegrid.RowCount);
          lib_editor.treegrid.RowCount:=2;
          while not mainform.tree_jingle.Eof do
          begin
            if UpperCase(mainform.tree_jingle.FieldByName('RBO_ID').AsString)=UpperCase(RBO_ID) then
            begin
              if  lib_editor.treegrid.cells[0,1]<>'' then  lib_editor.treegrid.rowcount:= lib_editor.treegrid.rowcount+1;
                  lib_editor.treegrid.cells[0,lib_editor.treegrid.rowcount-1]:=mainform.tree_jingle.FieldByName('List').AsString;
                  lib_editor.treegrid.cells[1,lib_editor.treegrid.rowcount-1]:=mainform.tree_jingle.FieldByName('Path').AsString;
                  lib_editor.treegrid.cells[2,lib_editor.treegrid.rowcount-1]:=mainform.tree_jingle.FieldByName('Indeks').AsString;
            end;
            mainform.tree_jingle.Next;
          end;
          {
          mainform.tree_jingle.First;
          while not mainform.tree_jingle.Eof do
          begin
            lib_editor.Memo1.Lines.Add(mainform.tree_jingle.FieldByName('List').AsString);
            mainform.tree_jingle.Next;
          end;
          }
       end;

       if namegrid='insertlib.dat' then
       begin
          mainform.tree_insert.First;
          lib_editor.treegrid.ClearRows(1,lib_editor.treegrid.RowCount);
          lib_editor.treegrid.RowCount:=2;
          while not mainform.tree_insert.Eof do
          begin
            if UpperCase(mainform.tree_insert.FieldByName('RBO_ID').AsString)=UpperCase(RBO_ID) then
            begin
              if  lib_editor.treegrid.cells[0,1]<>'' then  lib_editor.treegrid.rowcount:= lib_editor.treegrid.rowcount+1;
                  lib_editor.treegrid.cells[0,lib_editor.treegrid.rowcount-1]:=mainform.tree_insert.FieldByName('List').AsString;
                  lib_editor.treegrid.cells[1,lib_editor.treegrid.rowcount-1]:=mainform.tree_insert.FieldByName('Path').AsString;
                  lib_editor.treegrid.cells[2,lib_editor.treegrid.rowcount-1]:=mainform.tree_insert.FieldByName('Indeks').AsString;
            end;
            mainform.tree_insert.Next;
          end;

          {
          mainform.tree_insert.First;
          while not mainform.tree_insert.Eof do
          begin
            lib_editor.Memo1.Lines.Add(mainform.tree_insert.FieldByName('List').AsString);
            mainform.tree_insert.Next;
          end;
          }
       end;

    //lib_editor.Memo1.Lines.SaveToFile(workdir+'Share\'+namegrid);
    //lib_editor.treeGrid.LoadFromFile(workdir+'Share\'+namegrid);

    if lib_editor.treeGrid.RowCount<2 then
    begin
      lib_editor.treeGrid.RowCount:=2;
      lib_editor.treeGrid.FixedRows:=1;
      lib_editor.treeGrid.ClearRows(0,2);
    end;
    if lib_editor.treeGrid.ColCount<5 then lib_editor.treeGrid.ColCount:=5;
end;

procedure Tlib_editor.musiclibClick(Sender: TObject);
var i:integer;
begin
  label1.caption:='MUSIC LIBRARY';

  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  treeGrid.ClearRows(1,treeGrid.RowCount-1);
  treegrid.RowCount:=2;

  load_treelib('musiclib.dat');

  filelistbox.Update;
  drawtree('musiclib.dat');

  MusicLibTree.Update;
end;

procedure Tlib_editor.dirChange(Sender: TObject;
  Node: TTreeNode);
begin
  path_text.Caption:=dir.Path;
end;

procedure Tlib_editor.dirClick(Sender: TObject);
begin
  path_text.Caption:=dir.Path;
  abfedit1.Text:=dir.Selected.Text;
end;

procedure Tlib_editor.MMBitmapButton4Click(Sender: TObject);
var i:integer;
    namegrid,types:string;
begin
  if lib_editor.treeGrid.RowCount<2 then lib_editor.treeGrid.RowCount:=2;
  if abfedit1.Text<>'' then
  begin
       reloadform.Visible:=True;
       mainform.Enabled:=false;

       if label1.Caption='FILE EXPLORER'   then types:='OTHER';
       if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
       if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
       if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
       if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
       if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
       if label1.Caption='NEWS LIBRARY'    then types:='NEWS';
       if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';

       try
        mainform.Query2.SQL.Clear;
        mainform.Query2.SQL.Add('UPDATE db_song SET Kategori='+lbl1.Caption+abfedit1.Text+lbl1.Caption+
                                ' SET RBO_ID='+lbl1.Caption+RBO_ID+lbl1.Caption+
                                ' WHERE Kategori='+lbl1.Caption+treegrid.Cells[0,treegrid.row]+lbl1.Caption+
                                ' AND Type='+lbl1.Caption+types+lbl1.Caption+
                                ' AND RBO_ID='+lbl1.Caption+RBO_ID+lbl1.Caption);
        mainform.Query2.Active:=true;
        mainform.Query2.Close;
        mainform.Query2.Open;
        //mainform.Query2.execsql;
      except on e:exception do begin end; //ShowMessage(e.message)
      end;

       treegrid.Cells[0,treegrid.Row]:=abfedit1.Text;
       treegrid.Cells[1,treegrid.Row]:=path_text.Caption;

       if label1.caption='MUSIC LIBRARY'     then namegrid:='musiclib.dat';
       if label1.caption='INSERT LIBRARY'    then namegrid:='insertlib.dat';
       if label1.caption='JINGLES LIBRARY'   then namegrid:='jingleslib.dat';
       if label1.caption='COMM LIBRARY'      then namegrid:='commercialslib.dat';
       if label1.caption='ADLIBS LIBRARY'    then namegrid:='adlibslib.dat';
       if label1.caption='NEWS LIBRARY'      then namegrid:='newslib.dat';
       if label1.caption='OTHERS LIBRARY'    then namegrid:='otherslib.dat';

       drawtree(namegrid);
       update_treegrid(namegrid);


       if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);
       reloadform.Visible:=False;
       mainform.Enabled:=true;
       mainform.UpdateDatabase1.OnClick(Self);
  end else
  begin
    if languages=0 then else mainform.message.MessageDlg('Please type category name!',mtconfirmation,[mbok],0);
    if languages=1 then else mainform.message.MessageDlg('Ketik terlebih dahulu kategori yang akan dibuat!',mtconfirmation,[mbok],0);
  end;
end;
{
var i:integer;
    namegrid,types:string;
begin
  if lib_editor.treeGrid.RowCount<2 then lib_editor.treeGrid.RowCount:=2;
  if abfedit1.Text<>'' then
  begin
       reloadform.Visible:=True;
       mainform.Enabled:=false;

       if label1.Caption='FILE EXPLORER'   then types:='OTHER';
       if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
       if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
       if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
       if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
       if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
       if label1.Caption='NEWS LIBRARY'    then types:='NEWS';
       if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';

       mainform.db_song.First;
       while not  mainform.db_song.Eof do
       begin
        if ((mainform.db_song.FieldByName('RBO_ID').AsString=RBO_ID) and
            (mainform.db_song.FieldByName('Type').AsString  =types ) and
            (mainform.db_song.FieldByName('Kategori').AsString=treegrid.Cells[0,treegrid.row])) then
             begin
                mainform.db_song.Edit;
                mainform.db_song.FieldByName('Kategori').AsString:=abfedit1.Text;
                mainform.db_song.Post;
             end;
             mainform.db_song.Next;
       end;

       treegrid.Cells[0,treegrid.Row]:=abfedit1.Text;
       treegrid.Cells[1,treegrid.Row]:=path_text.Caption;

       if label1.caption='MUSIC LIBRARY'     then namegrid:='musiclib.dat';
       if label1.caption='INSERT LIBRARY'    then namegrid:='insertlib.dat';
       if label1.caption='JINGLES LIBRARY'   then namegrid:='jingleslib.dat';
       if label1.caption='COMM LIBRARY'      then namegrid:='commercialslib.dat';
       if label1.caption='ADLIBS LIBRARY'    then namegrid:='adlibslib.dat';
       if label1.caption='NEWS LIBRARY'      then namegrid:='newslib.dat';
       if label1.caption='OTHERS LIBRARY'    then namegrid:='otherslib.dat';

       drawtree(namegrid);
       update_treegrid(namegrid);

       //Treegrid.SaveTofile(workdir+'Share\'+namegrid);
       //Memo1.Lines.LoadFromFile(workdir+'Share\'+namegrid);

       if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);
       reloadform.Visible:=False;
       mainform.Enabled:=true;
  end else
  begin
    if languages=0 then else mainform.message.MessageDlg('Please type category name!',mtconfirmation,[mbok],0);
    if languages=1 then else mainform.message.MessageDlg('Ketik terlebih dahulu kategori yang akan dibuat!',mtconfirmation,[mbok],0);
  end;
end;
}

procedure Tlib_editor.delete_data;
var i,j:integer;
    namegrid,types:string;
begin
    if label1.Caption='FILE EXPLORER'   then types:='OTHER';
    if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
    if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
    if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
    if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
    if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
    if label1.Caption='NEWS LIBRARY'    then types:='NEWS';
    if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';

    reloadform.AdvProgress1.Max:=100;
    reloadform.AdvProgress1.Position:=100;
    mainform.db_song.First;
    while not  mainform.db_song.Eof do
    begin
        reloadform.AdvProgress1.Position:=reloadform.AdvProgress1.Position-1;
        if ((mainform.db_song.FieldByName('RBO_ID').AsString=RBO_ID) and
            (mainform.db_song.FieldByName('Type').AsString  =types ) and
            (mainform.db_song.FieldByName('Kategori').AsString=treegrid.Cells[0,treegrid.row])) then
             begin
                mainform.db_song.Delete;
             end else mainform.db_song.Next;
    end;

    if treegrid.RowCount>2 then treegrid.RemoveRows(treegrid.Row,1) else
    begin
      for j:=0 to 3 do treegrid.Cells[j,1]:='';
    end;

    abfedit1.Text:='';
    path_text.Caption:=dir.Path;

    if label1.caption='MUSIC LIBRARY'   then namegrid:='musiclib.dat';
    if label1.caption='INSERT LIBRARY'  then namegrid:='insertlib.dat';
    if label1.caption='JINGLES LIBRARY' then namegrid:='jingleslib.dat';
    if label1.caption='COMM LIBRARY'    then namegrid:='commercialslib.dat';
    if label1.caption='ADLIBS LIBRARY'  then namegrid:='adlibslib.dat';
    if label1.caption='NEWS LIBRARY'    then namegrid:='newslib.dat';
    if label1.caption='OTHERS LIBRARY'  then namegrid:='otherslib.dat';

    drawtree(namegrid);
    update_treegrid(namegrid);

    //Treegrid.SaveTofile(workdir+'Share\'+namegrid);
    //Memo1.Lines.LoadFromFile(workdir+'Share\'+namegrid);
    {
       if namegrid='newslib.dat' then
       begin
          mainform.tree_news.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_news.Append;
            mainform.tree_news.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_news.Post;
          end;
       end;

       if namegrid='otherslib.dat' then
       begin
          mainform.tree_other.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_other.Append;
            mainform.tree_other.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_other.Post;
          end;
       end;

       if namegrid='adlibslib.dat' then
       begin
          mainform.tree_adlib.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_adlib.Append;
            mainform.tree_adlib.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_adlib.Post;
          end;
       end;

       if namegrid='commercialslib.dat' then
       begin
          mainform.tree_commercial.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_commercial.Append;
            mainform.tree_commercial.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_commercial.Post;
          end;
       end;

       if namegrid='musiclib.dat' then
       begin
          mainform.db_treemusic.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.db_treemusic.Append;
            mainform.db_treemusic.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.db_treemusic.Post;
          end;
       end;

       if namegrid='jingleslib.dat' then
       begin
          mainform.tree_jingle.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_jingle.Append;
            mainform.tree_jingle.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_jingle.Post;
          end;
       end;

       if namegrid='insertlib.dat' then
       begin
          mainform.tree_insert.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_insert.Append;
            mainform.tree_insert.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_insert.Post;
          end;
       end;
    }

    if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);

    mainform.Enabled:=True;
    reloadform.Visible:=false;
    reloadform.AdvProgress1.Position:=0;
end;

procedure Tlib_editor.btnremoveClick(Sender: TObject);
var i,j:integer;
    namegrid,types:string;
begin
    if label1.Caption='FILE EXPLORER'   then types:='OTHER';
    if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
    if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
    if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
    if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
    if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
    if label1.Caption='NEWS LIBRARY'    then types:='NEWS';
    if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';

    reloadform.AdvProgress1.Max:=100;
    reloadform.AdvProgress1.Position:=100;

     try
      mainform.Query2.SQL.Clear;
      mainform.Query2.SQL.Add('DELETE FROM db_song WHERE Type='+lbl1.Caption+types+lbl1.Caption+
                              ' AND Kategori='+lbl1.Caption+treegrid.Cells[0,treegrid.row]+lbl1.Caption+
                              ' AND RBO_ID='+lbl1.Caption+RBO_ID+lbl1.Caption);
      mainform.Query2.Active:=true;
      mainform.Query2.Close;
      mainform.Query2.Open;
      //mainform.Query2.execsql;
    except on e:exception do begin end; //ShowMessage(e.message)
    end;


    if treegrid.RowCount>2 then treegrid.RemoveRows(treegrid.Row,1) else
    begin
      for j:=0 to 3 do treegrid.Cells[j,1]:='';
    end;

    abfedit1.Text:='';
    path_text.Caption:=dir.Path;

    if label1.caption='MUSIC LIBRARY'   then namegrid:='musiclib.dat';
    if label1.caption='INSERT LIBRARY'  then namegrid:='insertlib.dat';
    if label1.caption='JINGLES LIBRARY' then namegrid:='jingleslib.dat';
    if label1.caption='COMM LIBRARY'    then namegrid:='commercialslib.dat';
    if label1.caption='ADLIBS LIBRARY'  then namegrid:='adlibslib.dat';
    if label1.caption='NEWS LIBRARY'    then namegrid:='newslib.dat';
    if label1.caption='OTHERS LIBRARY'  then namegrid:='otherslib.dat';

    drawtree(namegrid);
    update_treegrid(namegrid);

    if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);

    mainform.Enabled:=True;
    reloadform.Visible:=false;
    reloadform.AdvProgress1.Position:=0;
    mainform.UpdateDatabase1.OnClick(Self);
end;
{
var i,j:integer;
    namegrid,types:string;
begin
  if lib_editor.treeGrid.RowCount<2 then lib_editor.treeGrid.RowCount:=2;

  if languages=0 then pesan:='Delete this category?';
  if languages=1 then pesan:='Hapus kategori ini?';

  if treegrid.Cells[0,treegrid.Row]<>'' then
  begin
  if mainform.message.MessageDlg(pesan,mtconfirmation,[mbyes,mbno],0)=mryes then
  begin
    reloadform.Visible:=True;
    mainform.Enabled:=False;
    tmr1.Enabled:=true;
  end else
  begin
    if languages=0 then mainform.message.MessageDlg('Please type category name!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Ketik terlebih dahulu kategori yang akan dibuat!',mtconfirmation,[mbok],0);
  end;
  end;

end;
}

procedure Tlib_editor.MMBitmapButton2Click(Sender: TObject);
var i,buffer:integer;
    namegrid:string;
begin
  if treegrid.Cells[0,treegrid.Row-1]<>'' then
  begin
     treegrid.SwapRows(treegrid.Row-1,treegrid.Row);
       if label1.caption='MUSIC LIBRARY'   then namegrid:='musiclib.dat';
       if label1.caption='INSERT LIBRARY'  then namegrid:='insertlib.dat';
       if label1.caption='JINGLES LIBRARY' then namegrid:='jingleslib.dat';
       if label1.caption='COMM LIBRARY'    then namegrid:='commercialslib.dat';
       if label1.caption='ADLIBS LIBRARY'  then namegrid:='adlibslib.dat';
       if label1.caption='NEWS LIBRARY'    then namegrid:='newslib.dat';
       if label1.caption='OTHERS LIBRARY'  then namegrid:='otherslib.dat';

      edits:=true;
      buffer:=treegrid.Row;
      drawtree(namegrid);
      treegrid.Row:=buffer;
      treegrid.Row:=treegrid.Row-1;
      Treegrid.SaveTofile(workdir+'Share\'+namegrid);
      if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);

      if namegrid='newslib.dat' then
       begin
          mainform.tree_news.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_news.Append;
            mainform.tree_news.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_news.Post;
          end;
       end;

      if namegrid='otherslib.dat' then
       begin
          mainform.tree_other.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_other.Append;
            mainform.tree_other.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_other.Post;
          end;
       end;

       if namegrid='adlibslib.dat' then
       begin
          mainform.tree_adlib.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_adlib.Append;
            mainform.tree_adlib.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_adlib.Post;
          end;
       end;

       if namegrid='commercialslib.dat' then
       begin
          mainform.tree_commercial.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_commercial.Append;
            mainform.tree_commercial.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_commercial.Post;
          end;
       end;

       if namegrid='musiclib.dat' then
       begin
          mainform.db_treemusic.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.db_treemusic.Append;
            mainform.db_treemusic.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.db_treemusic.Post;
          end;
       end;

       if namegrid='jingleslib.dat' then
       begin
          mainform.tree_jingle.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_jingle.Append;
            mainform.tree_jingle.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_jingle.Post;
          end;
       end;

       if namegrid='insertlib.dat' then
       begin
          mainform.tree_insert.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_insert.Append;
            mainform.tree_insert.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_insert.Post;
          end;
       end;
  end;
end;

procedure Tlib_editor.MMBitmapButton5Click(Sender: TObject);
var i,buffer:integer;
    namegrid:string;
begin
  if treegrid.Cells[0,treegrid.Row+1]<>'' then
  begin
     treegrid.SwapRows(treegrid.Row+1,treegrid.Row);
       if label1.caption='MUSIC LIBRARY'   then namegrid:='musiclib.dat';
       if label1.caption='INSERT LIBRARY'  then namegrid:='insertlib.dat';
       if label1.caption='JINGLES LIBRARY' then namegrid:='jingleslib.dat';
       if label1.caption='COMM LIBRARY'    then namegrid:='commercialslib.dat';
       if label1.caption='ADLIBS LIBRARY'  then namegrid:='adlibslib.dat';
       if label1.caption='NEWS LIBRARY'    then namegrid:='newslib.dat';
       if label1.caption='OTHERS LIBRARY'  then namegrid:='otherslib.dat';
     edits:=true;
      buffer:=treegrid.Row;
      drawtree(namegrid);
      treegrid.Row:=buffer;
     treegrid.Row:=treegrid.Row+1;
     Treegrid.SaveTofile(workdir+'Share\'+namegrid);
     if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);

     if namegrid='otherslib.dat' then
       begin
          mainform.tree_other.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_other.Append;
            mainform.tree_other.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_other.Post;
          end;
       end;

       if namegrid='newslib.dat' then
       begin
          mainform.tree_news.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_news.Append;
            mainform.tree_news.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_news.Post;
          end;
       end;

       if namegrid='adlibslib.dat' then
       begin
          mainform.tree_adlib.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_adlib.Append;
            mainform.tree_adlib.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_adlib.Post;
          end;
       end;

       if namegrid='commercialslib.dat' then
       begin
          mainform.tree_commercial.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_commercial.Append;
            mainform.tree_commercial.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_commercial.Post;
          end;
       end;

       if namegrid='musiclib.dat' then
       begin
          mainform.db_treemusic.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.db_treemusic.Append;
            mainform.db_treemusic.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.db_treemusic.Post;
          end;
       end;

       if namegrid='jingleslib.dat' then
       begin
          mainform.tree_jingle.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_jingle.Append;
            mainform.tree_jingle.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_jingle.Post;
          end;
       end;

       if namegrid='insertlib.dat' then
       begin
          mainform.tree_insert.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_insert.Append;
            mainform.tree_insert.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_insert.Post;
          end;
       end;
  end;

end;

procedure Tlib_editor.MMBitmapButton1Click(Sender: TObject);
var namegrid:string;
    i:integer;
begin
     if treegrid.Cells[2,treegrid.Row]<>'' then
     begin
      if (treegrid.Row=treegrid.RowCount-1) then
      begin
         treegrid.Cells[2,treegrid.Row]:=inttostr(strtoint(treegrid.Cells[2,treegrid.Row])-1);
      end else
      if (strtoint(treegrid.Cells[2,treegrid.Row])>1) and
         (strtoint(treegrid.Cells[2,treegrid.Row+1]) <= strtoint(treegrid.Cells[2,treegrid.Row])) then
      begin
        treegrid.Cells[2,treegrid.Row]:=inttostr(strtoint(treegrid.Cells[2,treegrid.Row])-1);
      end;
     end;

     if label1.caption='MUSIC LIBRARY'   then namegrid:='musiclib.dat';
     if label1.caption='INSERT LIBRARY'  then namegrid:='insertlib.dat';
     if label1.caption='JINGLES LIBRARY' then namegrid:='jingleslib.dat';
     if label1.caption='COMM LIBRARY'    then namegrid:='commercialslib.dat';
     if label1.caption='ADLIBS LIBRARY'  then namegrid:='adlibslib.dat';
     if label1.caption='NEWS LIBRARY'    then namegrid:='newslib.dat';
     if label1.caption='OTHERS LIBRARY'  then namegrid:='otherslib.dat';
     drawtree(namegrid);

     Treegrid.SaveTofile(workdir+'Share\'+namegrid);
     if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);
       //edits:=true;
     if namegrid='otherslib.dat' then
       begin
          mainform.tree_other.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_other.Append;
            mainform.tree_other.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_other.Post;
          end;
       end;

       if namegrid='newslib.dat' then
       begin
          mainform.tree_news.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_news.Append;
            mainform.tree_news.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_news.Post;
          end;
       end;

       if namegrid='adlibslib.dat' then
       begin
          mainform.tree_adlib.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_adlib.Append;
            mainform.tree_adlib.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_adlib.Post;
          end;
       end;

       if namegrid='commercialslib.dat' then
       begin
          mainform.tree_commercial.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_commercial.Append;
            mainform.tree_commercial.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_commercial.Post;
          end;
       end;

       if namegrid='musiclib.dat' then
       begin
          mainform.db_treemusic.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.db_treemusic.Append;
            mainform.db_treemusic.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.db_treemusic.Post;
          end;
       end;

       if namegrid='jingleslib.dat' then
       begin
          mainform.tree_jingle.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_jingle.Append;
            mainform.tree_jingle.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_jingle.Post;
          end;
       end;

       if namegrid='insertlib.dat' then
       begin
          mainform.tree_insert.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_insert.Append;
            mainform.tree_insert.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_insert.Post;
          end;
       end;
end;

procedure Tlib_editor.MMBitmapButton6Click(Sender: TObject);
var namegrid:string;
    i:integer;
begin
  if (treegrid.Row>1) then
  begin
  if treegrid.Cells[2,treegrid.Row]<>'' then
     begin
      if (strtoint(treegrid.Cells[2,treegrid.Row])<treegrid.RowCount-1) then
      begin
        treegrid.Cells[2,treegrid.Row]:=inttostr(strtoint(treegrid.Cells[2,treegrid.Row])+1);
      end else
      if (strtoint(treegrid.Cells[2,treegrid.Row])=strtoint(treegrid.Cells[2,treegrid.Row-1])) then
      begin
        treegrid.Cells[2,treegrid.Row]:=inttostr(strtoint(treegrid.Cells[2,treegrid.Row])+1);
      end;
     end;
  end;

  if label1.caption='MUSIC LIBRARY'   then namegrid:='musiclib.dat';
  if label1.caption='INSERT LIBRARY'  then namegrid:='insertlib.dat';
  if label1.caption='JINGLES LIBRARY' then namegrid:='jingleslib.dat';
  if label1.caption='COMM LIBRARY'    then namegrid:='commercialslib.dat';
  if label1.caption='ADLIBS LIBRARY'  then namegrid:='adlibslib.dat';
  if label1.caption='NEWS LIBRARY'    then namegrid:='newslib.dat';
  if label1.caption='OTHERS LIBRARY'  then namegrid:='otherslib.dat';
  drawtree(namegrid);
  Treegrid.SaveTofile(workdir+'Share\'+namegrid);
  if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);

      if namegrid='otherslib.dat' then
       begin
          mainform.tree_other.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_other.Append;
            mainform.tree_other.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_other.Post;
          end;
       end;

       if namegrid='newslib.dat' then
       begin
          mainform.tree_news.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_news.Append;
            mainform.tree_news.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_news.Post;
          end;
       end;

       if namegrid='adlibslib.dat' then
       begin
          mainform.tree_adlib.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_adlib.Append;
            mainform.tree_adlib.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_adlib.Post;
          end;
       end;

       if namegrid='commercialslib.dat' then
       begin
          mainform.tree_commercial.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_commercial.Append;
            mainform.tree_commercial.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_commercial.Post;
          end;
       end;

       if namegrid='musiclib.dat' then
       begin
          mainform.db_treemusic.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.db_treemusic.Append;
            mainform.db_treemusic.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.db_treemusic.Post;
          end;
       end;

       if namegrid='jingleslib.dat' then
       begin
          mainform.tree_jingle.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_jingle.Append;
            mainform.tree_jingle.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_jingle.Post;
          end;
       end;

       if namegrid='insertlib.dat' then
       begin
          mainform.tree_insert.EmptyTable;
          for i:=0 to Memo1.Lines.Count-1 do
          begin
            mainform.tree_insert.Append;
            mainform.tree_insert.FieldByName('List').AsString:=memo1.Lines.Strings[i];
            mainform.tree_insert.Post;
          end;
       end;
end;

procedure Tlib_editor.MusicLibTreeChange(Sender: TObject; Node: TTreeNode);
begin
  //if edits=false then
  begin
  if musiclibtree.Selected.Selected=true then
  if musiclibtree.Items.Count>0 then
     begin
      if musiclibtree.Selected.Selected then
      if musiclibtree.Selected.AbsoluteIndex>=0 then
      begin
        treegrid.Row:=musiclibtree.Selected.AbsoluteIndex+1;
        if directoryexists(treegrid.Cells[1,treegrid.row])=true then
           begin
            if directoryexists(treegrid.Cells[1,treegrid.row]) then
            begin
                dir.Path:=treegrid.Cells[1,treegrid.row];
                //showmessage(treegrid.Cells[1,treegrid.row]);
                dir.Update;
                dir.OnClick(self);
            end;
            abfedit1.Text:=treegrid.Cells[0,treegrid.row];
           end;
      end;
     end;
  end;

  mainform.db_treemusic.First;
  Memo1.Lines.Text:=mainform.db_treemusic.FieldByName('List').AsString;
end;

procedure Tlib_editor.bsSkinButton3Click(Sender: TObject);
var i:integer;
begin
  label1.caption:='INSERT LIBRARY';

  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  treeGrid.ClearRows(1,treeGrid.RowCount-1);
  treegrid.RowCount:=2;

  load_treelib('insertlib.dat');

  filelistbox.Update;
  drawtree('insertlib.dat');

  MusicLibTree.Update;
end;

procedure Tlib_editor.bsSkinButton4Click(Sender: TObject);
var i:integer;
begin
  label1.caption:='JINGLES LIBRARY';

  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  treeGrid.ClearRows(1,treeGrid.RowCount-1);
  treegrid.RowCount:=2;

  load_treelib('jingleslib.dat');

  filelistbox.Update;
  drawtree('jingleslib.dat');

  MusicLibTree.Update;
end;

procedure Tlib_editor.bsSkinButton5Click(Sender: TObject);
var i:integer;
begin
  label1.caption:='COMM LIBRARY';

  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  treeGrid.ClearRows(1,treeGrid.RowCount-1);
  treegrid.RowCount:=2;

  load_treelib('commercialslib.dat');

  filelistbox.Update;
  if lib_editor.treeGrid.RowCount<2 then lib_editor.treeGrid.RowCount:=2;
  drawtree('commercialslib.dat');

  MusicLibTree.Update;
end;

procedure Tlib_editor.bsSkinButton7Click(Sender: TObject);
var i:integer;
begin
  label1.caption:='ADLIBS LIBRARY';

  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  treeGrid.ClearRows(1,treeGrid.RowCount-1);
  treegrid.RowCount:=2;

  load_treelib('adlibslib.dat');

  filelistbox.Update;
  if treeGrid.RowCount<2 then treeGrid.RowCount:=2;
  drawtree('adlibslib.dat');

  MusicLibTree.Update;
end;

procedure Tlib_editor.bsSkinButton8Click(Sender: TObject);
var i:integer;
begin
  label1.caption:='OTHERS LIBRARY';

  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  treeGrid.ClearRows(1,treeGrid.RowCount-1);
  treegrid.RowCount:=2;
  treegrid.ColCount:=5;

  load_treelib('otherslib.dat');

  filelistbox.Update;
  if lib_editor.treeGrid.RowCount<2 then lib_editor.treeGrid.RowCount:=2;
  drawtree('otherslib.dat');

  MusicLibTree.Update;
end;

procedure Tlib_editor.FormCreate(Sender: TObject);
begin
  edits:=false;
  MusicLibTree.ChangeDelay:=100;
end;

procedure Tlib_editor.btn_playClick(Sender: TObject);
begin
    if fileexists(filelistbox.GetSelectedFile) then
    begin
      if IsMpegFile(filelistbox.GetSelectedFile) then
      begin
        musiclibrary.audiofile.FileName :=filelistbox.GetSelectedFile;
        musiclibrary.audiofile.FadeOutDuration:=1000;
        musiclibrary.audiofile.FadeInDuration:=500;
        musiclibrary.WaveOut.Input := musiclibrary.audiofile;
        musiclibrary.waveout.Stop;
        musiclibrary.waveout.Started;
      end;
    end else
    begin
      if languages=0 then mainform.message.MessageDlg('File doesnt exists!',mtconfirmation,[mbok],0);
      if languages=1 then mainform.message.MessageDlg('File tidak diketemukan!',mtconfirmation,[mbok],0);
    end;
end;

procedure Tlib_editor.btn_stopClick(Sender: TObject);
begin
    musiclibrary.audiofile.FadeOut(musiclibrary.audiofile.FadeOutDuration);
end;

procedure Tlib_editor.bsSkinButton1Click(Sender: TObject);
var i:integer;
begin
  label1.caption:='NEWS LIBRARY';

  treegrid.Clear;
  treegrid.RowCount:=2;
  treegrid.Row:=1;
  for i:=0 to treegrid.ColCount do treegrid.Cells[i,1]:='';

  treeGrid.ClearRows(1,treeGrid.RowCount-1);
  treegrid.RowCount:=2;

  load_treelib('newslib.dat');

  filelistbox.Update;
  if treeGrid.RowCount<2 then treeGrid.RowCount:=2;
  drawtree('newslib.dat');

  MusicLibTree.Update;
end;

procedure Tlib_editor.MMBitmapButton7Click(Sender: TObject);
var i,j:integer;
    namegrid,types:string;
begin
  if lib_editor.treeGrid.RowCount<2 then lib_editor.treeGrid.RowCount:=2;

  if languages=0 then pesan:='Delete all category?';
  if languages=1 then pesan:='Hapus semua kategori?';


  if mainform.message.MessageDlg(pesan,mtconfirmation,[mbyes,mbno],0)=mryes then
  begin

    reloadform.AdvProgress1.Max:=100;
    reloadform.AdvProgress1.Position:=100;
    mainform.Enabled:=false;
    tmr2.Enabled:=True;
    reloadform.Visible:=true;

    if label1.Caption='FILE EXPLORER'   then types:='OTHER';
    if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
    if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
    if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
    if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
    if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
    if label1.Caption='NEWS LIBRARY'    then types:='NEWS';
    if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';


    try
      mainform.Query2.SQL.Clear;
      mainform.Query2.SQL.Add('DELETE FROM db_song WHERE Type='+lbl1.Caption+types+lbl1.Caption+
                              ' AND RBO_ID='+lbl1.Caption+RBO_ID+lbl1.Caption);
      mainform.Query2.Active:=true;
      mainform.Query2.Close;
      mainform.Query2.Open;
      //mainform.Query2.execsql;
    except on e:exception do begin end; //ShowMessage(e.message)
    end;

    treeGrid.RowCount:=2;
    treeGrid.ColCount:=5;
    treeGrid.FixedRows:=1;
    treeGrid.ClearRows(0,2);

    abfedit1.Text:='';
    path_text.Caption:=dir.Path;

    if label1.caption='MUSIC LIBRARY'   then namegrid:='musiclib.dat';
    if label1.caption='INSERT LIBRARY'  then namegrid:='insertlib.dat';
    if label1.caption='JINGLES LIBRARY' then namegrid:='jingleslib.dat';
    if label1.caption='COMM LIBRARY'    then namegrid:='commercialslib.dat';
    if label1.caption='ADLIBS LIBRARY'  then namegrid:='adlibslib.dat';
    if label1.caption='NEWS LIBRARY'    then namegrid:='newslib.dat';
    if label1.caption='OTHERS LIBRARY'  then namegrid:='otherslib.dat';

    drawtree(namegrid);
    update_treegrid(namegrid);

    if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);

    tmr2.Enabled:=false;
    reloadform.Visible:=false;
    mainform.Enabled:=true;
    mainform.UpdateDatabase1.OnClick(Self);
  end;
end;
{
var i,j:integer;
    namegrid,types:string;
begin
  if lib_editor.treeGrid.RowCount<2 then lib_editor.treeGrid.RowCount:=2;

  if languages=0 then pesan:='Delete all category?';
  if languages=1 then pesan:='Hapus semua kategori?';


  if treegrid.Cells[0,treegrid.Row]<>'' then
  begin
    if mainform.message.MessageDlg(pesan,mtconfirmation,[mbyes,mbno],0)=mryes then
    begin

    reloadform.AdvProgress1.Max:=100;
    reloadform.AdvProgress1.Position:=100;
    mainform.Enabled:=false;
    tmr2.Enabled:=True;
    reloadform.Visible:=true;

    if label1.Caption='FILE EXPLORER'   then types:='OTHER';
    if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
    if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
    if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
    if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
    if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
    if label1.Caption='NEWS LIBRARY'    then types:='NEWS';
    if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';


    mainform.db_song.First;
    while not  mainform.db_song.Eof do
    begin
        if  (mainform.db_song.FieldByName('RBO_ID').AsString=RBO_ID) and
            (mainform.db_song.FieldByName('Type').AsString  =types ) then
             begin
                mainform.db_song.Delete;
             end else mainform.db_song.Next;
    end;

    treeGrid.RowCount:=2;
    treeGrid.ColCount:=5;
    treeGrid.FixedRows:=1;
    treeGrid.ClearRows(0,2);

    abfedit1.Text:='';
    path_text.Caption:=dir.Path;

    if label1.caption='MUSIC LIBRARY'   then namegrid:='musiclib.dat';
    if label1.caption='INSERT LIBRARY'  then namegrid:='insertlib.dat';
    if label1.caption='JINGLES LIBRARY' then namegrid:='jingleslib.dat';
    if label1.caption='COMM LIBRARY'    then namegrid:='commercialslib.dat';
    if label1.caption='ADLIBS LIBRARY'  then namegrid:='adlibslib.dat';
    if label1.caption='NEWS LIBRARY'  then namegrid:='newslib.dat';
    if label1.caption='OTHERS LIBRARY'    then namegrid:='otherslib.dat';

    drawtree(namegrid);
    update_treegrid(namegrid);
    if musiclibrary.Visible=true then musiclibrary.bsSkinButton2.OnClick(self);

    tmr2.Enabled:=false;
    reloadform.Visible:=false;
    mainform.Enabled:=true;
  end else
  begin
    if languages=0 then mainform.message.MessageDlg('Please type category name!',mtconfirmation,[mbok],0);
    if languages=1 then mainform.message.MessageDlg('Ketik terlebih dahulu kategori yang akan dibuat!',mtconfirmation,[mbok],0);
  end;
  end;

end;
}

procedure  Tlib_editor.reload_all;
var i,j:integer;
    namegrid,types,rate:string;
begin
  if treegrid.Cells[0,treegrid.Row]<>'' then
  begin
    if label1.Caption='FILE EXPLORER'   then types:='OTHER';
    if label1.Caption='MUSIC LIBRARY'   then types:='MUSIC';
    if label1.Caption='INSERT LIBRARY'  then types:='INSERT';
    if label1.Caption='JINGLES LIBRARY' then types:='JINGLE';
    if label1.Caption='COMM LIBRARY'    then types:='COMMERCIAL';
    if label1.Caption='ADLIBS LIBRARY'  then types:='ADLIB';
    if label1.Caption='NEWS LIBRARY'    then types:='NEWS';
    if label1.Caption='OTHERS LIBRARY'  then types:='OTHER';

    mainform.db_song.First;
    while not  mainform.db_song.Eof do
    begin
        if  (mainform.db_song.FieldByName('RBO_ID').AsString=RBO_ID) and
            (mainform.db_song.FieldByName('Type').AsString  =types ) then
             begin
                mainform.db_song.Delete;
             end else mainform.db_song.Next;
    end;

    mmo1.Lines.Clear;
    reloadform.AdvProgress1.Position:=0;
    reloadform.AdvProgress1.Visible:=True;
    reloadform.AdvProgress1.Max:=treeGrid.RowCount-1;
    for i:=1 to treeGrid.RowCount-1 do
    begin
      reloadform.AdvProgress1.Position:=i;
      if treeGrid.Cells[0,i]<>'' then
      begin
          if reloadform.Visible=False then Break;
          fllst1.Directory:=treeGrid.Cells[1,i];
          fllst1.Update;
          //Sleep(1000);

          reloadform.AdvProgress2.Max:= fllst1.Items.Count;
          for j:=0 to fllst1.Items.Count-1 do
          begin
              reloadform.AdvProgress2.Position:=j;
              if FileExists(fllst1.Directory+'\'+fllst1.Items.Strings[j]) then
              begin
                if reloadform.Visible=False then Break;
                //mmo1.Lines.Add(fllst1.Directory+'\'+fllst1.Items.Strings[j]);

                if chk2.Checked=true then
                begin
                  mpegfile1.FreeMpeg;
                  if IsMpegFile(fllst1.Items.Strings[j])=true then
                  begin
                    mpegfile1.FileName:=fllst1.Items.Strings[j];
                    rate:=inttostr(mpegfile1.Frames * mpegfile1.TimePerFrame);
                    mpegfile1.FreeMpeg;
                  end;
                end;
                //

                mainform.db_song.Append;
                mainform.db_song.FieldByName('RBO_ID').AsString:=RBO_ID;
                mainform.db_song.FieldByName('Type').AsString  :=types;
                mainform.db_song.FieldByName('Filename').AsString:=fllst1.Items.Strings[j];
                mainform.db_song.FieldByName('Artist').AsString:='-';
                mainform.db_song.FieldByName('Album').AsString:='-';
                mainform.db_song.FieldByName('Genre').AsString:='-';
                mainform.db_song.FieldByName('Year').AsString:='-';
                mainform.db_song.FieldByName('Path').AsString:=fllst1.Directory+'\'+fllst1.Items.Strings[j];
                mainform.db_song.FieldByName('Kategori').AsString:=treegrid.Cells[0,i];
                mainform.db_song.FieldByName('Rate').AsString:=rate;
                //
                mainform.db_song.Post;
              end;
          end;
      end;
    end;
    reloadform.AdvProgress1.Visible:=false;
  end;
  reloadform.Visible:=false;
  mainform.Enabled:=True;
end;

procedure Tlib_editor.MMBitmapButton8Click(Sender: TObject);
var i,j:integer;
    namegrid,types:string;
begin
  mainform.Enabled:=false;
  reloadform.Visible:=true;
  tmr_tmr.Enabled:=True;
end;

procedure Tlib_editor.tmr_tmrTimer(Sender: TObject);
begin
  tmr_tmr.Enabled:=false;
  reload_all;
end;

procedure Tlib_editor.tmr1Timer(Sender: TObject);
begin
  tmr1.Enabled:=false;
  delete_data;
end;

procedure Tlib_editor.tmr2Timer(Sender: TObject);
begin
    reloadform.AdvProgress1.Position:=reloadform.AdvProgress1.Position-1;
    if reloadform.AdvProgress1.Position<=0 then
    begin
      tmr2.Enabled:=false;
    end;
end;

procedure Tlib_editor.tmr3Timer(Sender: TObject);
begin
  tmr3.Enabled:=false;
  reloadlib(namegrids);
end;

end.
